********************************************************************************
/*————————————————————————————————————Analysis————————————————————————————————*/
********************************************************************************
clear all
set more on
set mat 800
capture log close

cd "$E"

global path "E:\Project1_empirical" // global path file
global census  "$path\Census"     // census data
global city    "$path\City"       // city yearbook
global iv      "$path\IV"         // IV dataset
global chips   "$path\CHIPs"      // CHIPs dataset
global working_data = "$path\3rd Edition (Age 20 to 30)\Working Data" // working data be used in regression

use "$working_data\temp", clear

drop if code==.

gen edu_gap=hedu-wedu 
gen age_gap=hage-wage
gen edugap=abs(edu_gap) //absolute gap//
gen agegap=abs(age_gap) //absolute gap//
gen age_gap2=age_gap*age_gap

tab year, gen(yr)

gen hedu_yr1=hedu*yr1
gen hedu_yr2=hedu*yr2
gen hedu_yr3=hedu*yr3
gen lnpopdensity=ln(popdensity)
gen lngdppc=ln(gdppc)
gen lnavewage=ln(avewage)
gen lnfdi=ln(fdi)
gen lndeposits=ln(deposits)
gen lncolleges=ln(colleges)
gen lnhighschools=ln(highschools)
gen inter=hedu*srpref
gen lnpoppref=ln(poppref)
gen lnuniteachers=ln(uniteachers)
gen lnhschoolteachers=ln(hschoolteachers)

global xlist hage wage hhukou whukou hmin wmin

global zlist share2030 lngdppc lnavewage lnfdi lndeposits ///
lncolleges lnhighschools lnuniteachers lnhschoolteachers

********************************************************************************
***                               Analysis                                   ***
********************************************************************************
* c.hedu##c.srpref
* regerssion 2 interaction term *
eststo rc1: qui reg wedu hedu srpref inter, r cluster(prefect)  //without controls//

eststo rc2: qui reg wedu hedu srpref inter ///
$zlist, r cluster(prefect) /*control city info */
 
eststo rc3: qui reg wedu hedu srpref inter ///
$xlist $zlist, r cluster(prefect)

eststo rc4: qui reg wedu hedu srpref inter ///
$xlist $zlist i.year, r cluster(prefect)
 
eststo rc5: xi: qui areg wedu hedu srpref inter ///
$zlist $xlist i.year, absorb(prefect) r cluster(prefect) /* same as i.prefect */


estout rc*, cells(b(star fmt(%8.2f)) se(par)) drop(_cons)  starlevels(* .10 ** .05 *** .01) ///
        stats(r2 N, fmt(%8.2f %8.1f %8.0g) ) replace 

esttab using "$working_data\reg2.tex", ///
label b(2) se(2) r2(2) ///
title(interaction term) ///
addnote("Source: CHIPs, China City Statistical Yearbook, Census 2000, 2010") replace

/*
--------------------------------------------------------------------------------------------
                      rc1             rc2             rc3             rc4             rc5   
                     b/se            b/se            b/se            b/se            b/se   
--------------------------------------------------------------------------------------------
hedu                 1.33***         1.38***         1.36***         1.36***         1.37** 
                   (0.45)          (0.48)          (0.46)          (0.47)          (0.53)   
srpref               6.89            8.44            7.91            7.91            5.49   
                   (5.51)          (6.00)          (5.88)          (5.93)          (8.37)   
hedu                 0.00                                                                   
                      (.)                                                                   
srpref               0.00                                                                   
                      (.)                                                                   
c.hedu#c.s~f        -0.59           -0.65           -0.66           -0.66           -0.69   
                   (0.44)          (0.47)          (0.45)          (0.45)          (0.51)   
srpref                                                                               0.00   
                                                                                      (.)   
srpref                                                               0.00                   
                                                                      (.)                   
srpref                                               0.00                                   
                                                      (.)                                   
srpref                               0.00                                                   
                                      (.)                                                   
hedu                                 0.00                                                   
                                      (.)                                                   
share2030                           -2.57           -1.53           -1.58           13.43*  
                                   (2.05)          (2.06)          (2.08)          (7.77)   
lnpopdensity                        -0.02           -0.13           -0.14           -0.40   
                                   (0.14)          (0.14)          (0.15)          (0.40)   
lngdppc                              0.21            0.13            0.15            0.20   
                                   (0.19)          (0.18)          (0.19)          (0.53)   
lnavewage                            0.10            0.20            0.15            2.30*  
                                   (0.26)          (0.25)          (0.50)          (1.33)   
lnfdi                               -0.13*          -0.08           -0.09           -0.12   
                                   (0.08)          (0.08)          (0.08)          (0.28)   
lndeposits                           0.22            0.19            0.20            0.00   
                                   (0.21)          (0.20)          (0.22)          (0.96)   
colleges                             0.00            0.00            0.00           -0.05** 
                                   (0.00)          (0.00)          (0.00)          (0.02)   
highschools                          0.00            0.00            0.00           -0.00   
                                   (0.00)          (0.00)          (0.00)          (0.00)   
hage                                                -0.70           -0.70           -0.80   
                                                   (0.86)          (0.86)          (1.23)   
wage                                                 1.38**          1.38**          1.29*  
                                                   (0.60)          (0.61)          (0.66)   
hhukou                                               0.21            0.22            0.38   
                                                   (0.26)          (0.27)          (0.33)   
whukou                                               1.27***         1.26***         1.15***
                                                   (0.24)          (0.24)          (0.30)   
hmin                                                -0.14           -0.12            0.01   
                                                   (0.61)          (0.62)          (0.72)   
wmin                                                -0.41           -0.40           -0.67   
                                                   (0.58)          (0.58)          (0.65)   
hage2                                                0.01            0.01            0.01   
                                                   (0.02)          (0.02)          (0.02)   
wage2                                               -0.02**         -0.02**         -0.02*  
                                                   (0.01)          (0.01)          (0.01)   
hedu                                                 0.00                                   
                                                      (.)                                   
hedu                                                                 0.00                   
                                                                      (.)                   
2002.year                                                            0.00            0.00   
                                                                      (.)             (.)   
2007.year                                                            0.14           -1.15   
                                                                   (0.33)          (1.03)   
2013.year                                                            0.09           -2.63   
                                                                   (0.58)          (2.13)   
hedu                                                                                 0.00   
                                                                                      (.)   
1101.prefect                                                                         0.00   
                                                                                     (.)   
.
.
.																					 
--------------------------------------------------------------------------------------------
r2                   0.52            0.53            0.57            0.57            0.61   
N                   847.0           754.0           754.0           754.0           754.0   
--------------------------------------------------------------------------------------------
*/

		
/*		
* regression 3 "hedu-wedu" *
eststo rc1: qui reg edu_gap srpref, cluster(prefect) //without controls//
eststo rc2: qui reg edu_gap srpref ///
$zlist , cluster(prefect)  /*control city info */

eststo rc3: qui reg edu_gap age_gap hhukou whukou hmin wmin age_gap2 srpref ///
$zlist , cluster(prefect)

eststo rc4: qui reg edu_gap age_gap hhukou whukou hmin wmin age_gap2 srpref ///
$zlist i.year, cluster(prefect)

eststo rc5: qui reg edu_gap age_gap hhukou whukou hmin wmin age_gap2 srpref ///
$zlist i.year i.prefect, cluster(prefect)

estout rc*, cells(b(star fmt(%8.2f)) se(par)) drop(_cons)  starlevels(* .10 ** .05 *** .01) ///
        stats(r2 N, fmt(%8.2f %8.1f %8.0g) ) replace 
*/


* regression 3 *
eststo clear

eststo rd1: qui reg edugap srpref, r cluster(prefect) //without controls//

eststo rd2: qui reg edugap srpref ///
$zlist, r cluster(prefect) /*control city info */

eststo rd3: qui reg edugap agegap hhukou whukou hmin wmin age_gap2 srpref ///
$zlist, r cluster(prefect)

eststo rd4: qui reg edugap agegap hhukou whukou hmin wmin age_gap2 srpref ///
$zlist i.year, r cluster(prefect)

eststo rd5: xi: qui areg edugap agegap hhukou whukou hmin wmin age_gap2 srpref ///
$zlist i.year, absorb(prefect) r cluster(prefect) 

estout rd*, cells(b(star fmt(%8.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2 N, fmt(%8.2f %8.1f %8.0g) ) replace 
		
esttab using "$working_data\reg3.tex", ///
label b(2) se(2) r2(2) ///
title(education gap between spouse) ///
addnote("Source: CHIPs, China City Statistical Yearbook, Census 2000, 2010") replace

/*	
--------------------------------------------------------------------------------------------
                      rd1             rd2             rd3             rd4             rd5   
                     b/se            b/se            b/se            b/se            b/se   
--------------------------------------------------------------------------------------------
srpref               0.59            2.48*           2.68*           3.07**          6.72** 
                   (0.98)          (1.46)          (1.44)          (1.51)          (2.57)   
share2030                            3.90**          3.83**          3.75**         -3.08   
                                   (1.93)          (1.91)          (1.85)          (4.45)   
lnpopdensity                        -0.17*          -0.15           -0.14           -1.02** 
                                   (0.10)          (0.10)          (0.11)          (0.48)   
lngdppc                              0.18            0.22            0.23            1.00*  
                                   (0.20)          (0.19)          (0.19)          (0.58)   
lnavewage                            0.07            0.05           -0.55           -0.14   
                                   (0.23)          (0.23)          (0.37)          (1.21)   
lnfdi                                0.20**          0.18*           0.17*           0.18   
                                   (0.09)          (0.09)          (0.09)          (0.24)   
lndeposits                          -0.66***        -0.65***        -0.57***        -1.14   
                                   (0.22)          (0.22)          (0.22)          (0.87)   
colleges                             0.01*           0.01*           0.01*           0.02*  
                                   (0.00)          (0.00)          (0.00)          (0.01)   
highschools                          0.00***         0.00***         0.00***        -0.00   
                                   (0.00)          (0.00)          (0.00)          (0.00)   
agegap                                               0.10            0.10            0.14   
                                                   (0.10)          (0.10)          (0.11)   
hhukou                                               0.54**          0.56**          0.59*  
                                                   (0.26)          (0.26)          (0.30)   
whukou                                              -0.48**         -0.48**         -0.41** 
                                                   (0.20)          (0.19)          (0.20)   
hmin                                                 0.31            0.32            0.51   
                                                   (0.49)          (0.49)          (0.59)   
wmin                                                -0.45           -0.47           -0.56   
                                                   (0.50)          (0.49)          (0.56)   
age_gap2                                             0.01            0.00           -0.00   
                                                   (0.01)          (0.02)          (0.02)   
2002.year                                                            0.00            0.00   
                                                                      (.)             (.)   
2007.year                                                            0.58*           0.34   
                                                                   (0.31)          (1.04)   
2013.year                                                            0.87           -0.16   
                                                                   (0.54)          (2.22)   
1101.prefect                                                                         0.00   
                                                                                      (.)   
1401.prefect                                                                        -0.50   
                                                                                   (2.96)   
.
.
.																				   
_cons                0.83            4.45**          3.78**          7.62***         9.05   
                   (1.01)          (1.86)          (1.85)          (2.68)         (18.07)   
--------------------------------------------------------------------------------------------
r2                   0.00            0.03            0.05            0.05            0.18   
N                   847.0           754.0           754.0           754.0           754.0   
--------------------------------------------------------------------------------------------																			   
*/	


/* regression 4 *
eststo reg1: qui reg wedu hedu hedu_yr1 hedu_yr2 hedu_yr3 yr1 yr2 yr3
estout, cells(b(star fmt(%8.2f)) se(par)) drop(_cons)  starlevels(* .10 ** .05 *** .01) ///
        stats(r2 N, fmt(%8.2f %8.1f %8.0g) ) replace 
esttab using reg1.tex, label se r2 title(assortative matching over time) addnote("Source: CHIPs 2002, 2007, 2013")

eststo clear		
/*esttab using UHS.tex, label se ar2 title(Sex Ratios and Education and Labor Market Outcomes) addnote("Source: Urban Household Surveys, 1988-2006.") /*
      */ keep(mlratio lratio male) replace */

*esttab using reg1.tex, label se ar2 title() addnote("Source: Urban Household Surveys, 1988-2006.") replace
----------------------------
                      ra1   
                     b/se   
----------------------------
hedu                 0.00   
                      (.)   
hedu_yr1             0.68***
                   (0.05)   
hedu_yr2             0.67***
                   (0.04)   
hedu_yr3             0.78***
                   (0.04)   
yr1                 -0.37   
                   (0.87)   
yr2                  0.00   
                      (.)   
yr3                 -1.14   
                   (0.73)   
----------------------------
r2                   0.52   
N                   847.0   
----------------------------
*/


